.586p
.model flat, stdcall
option casemap:none

; 
.nolist
include	usewdm.inc
includelib	wdm.lib
.list
include	ioctlcodes.inc

; --------------------------------------------------------------------------------------
; 
.data

;  
szMessage1	db "ASMDRV.SYS -- Hello! This is ASMDRV.sys!",0
szMessage2	db "ASMDRV.SYS -- OnUnload() enter",0
szMessage3	db "ASMDRV.SYS -- Parameter == %08X",0
szMessage4	db "ASMDRV.SYS -- OnDispatch()",0
szMessage5	db "ASMDRV.SYS -- IRP_MJ_CREATE",0
szMessage6	db "ASMDRV.SYS -- IRP_MJ_CLOSE",0
szMessage7	db "ASMDRV.SYS -- IRP_MJ_DEVICE_CONTROL",0
szmsgpattern	db "ASMDRV.SYS -- %s 0x%08X",0
szioctl_1		db "ASMDRV.SYS -- IOCTL_USER_REQUEST_1",0
szioctl_2		db "ASMDRV.SYS -- IOCTL_USER_REQUEST_2",0
szprintpattern	db "ASMDRV.SYS --  : %s",0

;   NT
wsNtDeviceName  dw '\','D','e','v','i','c','e','\','S','a','m','p','l','e','A','s','m','D','r','v',0

;  
wsWin32DeviceName dw '\','D','o','s','D','e','v','i','c','e','s','\','S','a','m','p','l','e','A','s','m','D','r','v',0

NtDeviceName		UNICODE_STRING	{0,0,0}
Win32DeviceName	UNICODE_STRING	{0,0,0}

;   device object
DeviceObject PDEVICE_OBJECT 0

; --------------------------------------------------------------------------------------
; 
.code

; --------------------------------------------------------------------------------------
;     
; --------------------------------------------------------------------------------------
DriverEntry proc near public, DriverObject:PDRIVER_OBJECT, RegistryPath:PUNICODE_STRING
	LOCAL		Status:DWORD
	mov Status,STATUS_SUCCESS	;  

	invoke DbgPrint, offset szMessage1	;  .  DbgView.

	;        
	invoke RtlInitUnicodeString, offset NtDeviceName, offset wsNtDeviceName
	invoke RtlInitUnicodeString, offset Win32DeviceName, offset wsWin32DeviceName

	push ebx ;   WDM     ebx,       .
	mov ebx,DriverObject
	mov (DRIVER_OBJECT ptr [ebx]).DriverUnload, offset OnUnload
	mov eax, offset OnDispatch
	mov (DRIVER_OBJECT ptr [ebx]).MajorFunction[IRP_MJ_CREATE * (TYPE PDRIVER_DISPATCH)],eax
	mov (DRIVER_OBJECT ptr [ebx]).MajorFunction[IRP_MJ_CLOSE * (TYPE PDRIVER_DISPATCH)],eax
	mov (DRIVER_OBJECT ptr [ebx]).MajorFunction[IRP_MJ_DEVICE_CONTROL * (TYPE PDRIVER_DISPATCH)],eax
	pop ebx

	;    
	invoke IoCreateDevice, DriverObject, 0, offset NtDeviceName, FILE_DEVICE_UNKNOWN,0,FALSE,offset DeviceObject;
	cmp eax,STATUS_SUCCESS	; ,    .
	jnz @F
	
	;  symbolic link
	invoke IoCreateSymbolicLink, offset Win32DeviceName, offset NtDeviceName	;  eax   

 @@:
	ret
DriverEntry endp

; --------------------------------------------------------------------------------------
;    
; --------------------------------------------------------------------------------------
OnUnload proc near, DriverObject:PDRIVER_OBJECT
	;   
	invoke IoDeleteSymbolicLink, offset Win32DeviceName

	;   
	invoke IoDeleteDevice, DeviceObject

	;   
	invoke RtlFreeUnicodeString,offset NtDeviceName
	invoke RtlFreeUnicodeString,offset Win32DeviceName

	ret
OnUnload endp

; --------------------------------------------------------------------------------------
;    device IO control
; Re:    eax   
; --------------------------------------------------------------------------------------
DeviceIoControlHandler proc near, Code:ULONG, pBuffer:PCHAR, InputBufferLength:ULONG, OutputBufferLength:ULONG, pOutputLength:PULONG
	mov eax,Code		; . ,      .
	cmp eax,IOCTL_USER_REQUEST_1	;   1 --   
	jz	IoCtl_1
	cmp eax,IOCTL_USER_REQUEST_2	;   2 --     
	jz	IoCtl_2
	; <...> --  
	mov eax,STATUS_NOT_IMPLEMENTED	;   
	ret

 IoCtl_1:
	invoke DbgPrint, offset szioctl_1	
	mov eax,InputBufferLength	;     --     .
	cmp eax,0
	jz @F
	invoke DbgPrint, offset szprintpattern, pBuffer	;      
 @@:
	mov eax,STATUS_SUCCESS
	ret

 IoCtl_2:
	invoke DbgPrint, offset szioctl_2
	;       
	push ebx

	mov eax,OutputBufferLength	; ,       ...
	cmp eax,0			; ...     .
	jz  loc_cycle_leave_001
	cmp eax,InputBufferLength
	jnz loc_cycle_leave_001

	mov ebx,pBuffer
 @@:	mov al,BYTE ptr [ebx]
	inc ebx
	cmp al,0
	jz loc_cycle_leave_001

	cmp al,0E0H
	jae loc_4798
	cmp al,40H
	jbe loc_4798
	cmp al,5FH
	jbe loc_4793
	cmp al,0C0H
	jae loc_4793
	jmp loc_4798

 loc_4793:
	add al,20H

 loc_4798:
	mov BYTE ptr [ebx-1],al
	
	jmp @B
 loc_cycle_leave_001:

	mov eax,OutputBufferLength
	mov ebx,pOutputLength	;  ,    .
	mov DWORD ptr [ebx],eax
	
	pop ebx

	mov eax,OutputBufferLength
	cmp eax,0
	jz @F
	invoke DbgPrint, offset szprintpattern, pBuffer	;       ( )
 @@:

	mov eax,STATUS_SUCCESS
	ret
DeviceIoControlHandler endp

; <...>

; --------------------------------------------------------------------------------------
;   IRP_MJ_XXX
; --------------------------------------------------------------------------------------
OnDispatch proc near, pDeviceObject:PDEVICE_OBJECT,pIrp:PIRP
	LOCAL Status:DWORD		;     
	LOCAL pIrpStack:DWORD	;    IO_STACK_LOCATION

	LOCAL Code			;    DeviceIoControl
	LOCAL InputBufferLength	;    
	LOCAL OutputBufferLength	;    
	LOCAL pBuffer			;    

	mov Status,STATUS_UNSUCCESSFULL

	invoke DbgPrint, offset szMessage4

	push ebx
	mov ebx,pIrp
	mov eax,(_IRP ptr [ebx]).Tail.Overlay.CurrentStackLocation	;     IO_STACK_LOCATION
	mov pIrpStack,eax

	mov ebx,pIrpStack
	mov al,(IO_STACK_LOCATION ptr [ebx]).MajorFunction	;  
	pop ebx

	cmp al,IRP_MJ_CREATE
	jnz @F
	; IRP_MJ_CREATE -- CreateFile()...
		invoke DbgPrint, offset szMessage5
	; <...> --   
	mov Status,STATUS_SUCCESS	;  ,  !
	jmp OnDispatchLeave

 @@:	cmp al,IRP_MJ_CLOSE
	jnz @F
	; IRP_MJ_CLOSE -- CloseHandle()...
		invoke DbgPrint, offset szMessage6
	; <...> --   
	mov Status,STATUS_SUCCESS
	jmp OnDispatchLeave

 @@:	cmp al,IRP_MJ_DEVICE_CONTROL
	jnz @F
	; IRP_MJ_DEVICE_CONTROL -- DeviceIoControl()...
		invoke DbgPrint, offset szMessage7

	push ebx
	mov ebx,pIrp
		;     
	mov eax,(_IRP ptr [ebx]).AssociatedIrp.SystemBuffer
	mov pBuffer,eax

	mov ebx,pIrpStack	;    . 
				; ,    ,     DeviceIoControlHandler
		;   
	mov eax,(IO_STACK_LOCATION ptr [ebx]).Parameters.DeviceIoControl.IoControlCode
	mov Code,eax
		;    
	mov eax,(IO_STACK_LOCATION ptr [ebx]).Parameters.DeviceIoControl.InputBufferLength
	mov InputBufferLength,eax
		;    
	mov eax,(IO_STACK_LOCATION ptr [ebx]).Parameters.DeviceIoControl.OutputBufferLength
	mov OutputBufferLength,eax
	mov ebx,pIrp

	xor eax,eax					;    
	mov (_IRP ptr [ebx]).IoStatus.Information,eax
	mov eax,ebx					;      Information     
	add eax,offset _IRP.IoStatus.Information
	pop ebx
		;  .	
	invoke DeviceIoControlHandler, Code, pBuffer, InputBufferLength, OutputBufferLength, eax
	mov Status,eax	;   
	
	jmp OnDispatchLeave
 @@:	; default
	mov Status,STATUS_NOT_IMPLEMENTED

 OnDispatchLeave:

	mov ecx,pIrp	;   -     
	mov edx,0
	call @IofCompleteRequest@8

	mov eax,Status	;   
	push ebx
	mov ebx,pIrp
	mov (_IRP ptr [ebx]).IoStatus.Status,eax
	pop ebx
	ret
OnDispatch endp

;

end
