unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    ListBox1: TListBox;
    GroupBox3: TGroupBox;
    GroupBox4: TGroupBox;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    StaticText1: TStaticText;
    Edit1: TEdit;
    Button4: TButton;
    StaticText2: TStaticText;
    Edit2: TEdit;
    StaticText3: TStaticText;
    StaticText4: TStaticText;
    Timer1: TTimer;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }

    hdrv : cardinal; //   asmdrv.sys

  end;

const
 IOCTL_USER_REQUEST_1 : cardinal = $00220010; //     
 IOCTL_USER_REQUEST_2 : cardinal = $00220020; //     

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
var
 err : integer;
begin
 //  "  "
 if hdrv<>INVALID_HANDLE_VALUE then Button2.Click(); //    (Windows 9X).
 SetLastError(NO_ERROR);
 hdrv := CreateFile('\\.\SampleAsmDrv',            // hdrv
                    GENERIC_READ    or GENERIC_WRITE,
                    FILE_SHARE_READ or FILE_SHARE_WRITE,
                    nil,
                    OPEN_EXISTING,
                    FILE_ATTRIBUTE_NORMAL,
                    0);

 if hdrv=INVALID_HANDLE_VALUE then
 begin
  err := GetLastError();
  ListBox1.Items.Add(AnsiString(' ') + IntToStr(err));
 end  else
 begin
  ListBox1.Items.Add(' .');
 end;

end;

procedure TForm1.FormCreate(Sender: TObject);
begin
 hdrv := INVALID_HANDLE_VALUE;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
 //  " "
 if hdrv=INVALID_HANDLE_VALUE then
  ListBox1.Items.Add('  .')
                              else
 begin
  CloseHandle(hdrv);
  hdrv := INVALID_HANDLE_VALUE;
  ListBox1.Items.Add(' .');
 end;
end;

procedure TForm1.Button3Click(Sender: TObject);
var
 cb  : cardinal;
 err : integer;
begin
 //  " IOCTL_USER_REQUEST_1"
 if hdrv<>INVALID_HANDLE_VALUE then
 begin
  cb:=0;
  SetLastError(NO_ERROR);
  DeviceIoControl( hdrv,
                   IOCTL_USER_REQUEST_1,
                   PChar(Edit1.Text), 1+Length(Edit1.Text),
                   nil,0,
                   cb,
                   nil );
  err := GetLastError();
  if err<>NO_ERROR then
  begin
   ListBox1.Items.Add(AnsiString('USER_REQUEST_1:  ') + IntToStr(err));
  end else
  begin
   ListBox1.Items.Add('USER_REQUEST_1:   .');
  end;
 end else
  ListBox1.Items.Add('    ');
end;

procedure TForm1.Button4Click(Sender: TObject);
var
 cb  : cardinal;
 err : integer;
 st  : AnsiString;
begin
 //  " IOCTL_USER_REQUEST_2"
 if hdrv<>INVALID_HANDLE_VALUE then
 begin
  st := Edit2.Text;
  cb:=0;
  SetLastError(NO_ERROR);
  DeviceIoControl( hdrv,
                   IOCTL_USER_REQUEST_2,
                   PChar(st), 1+Length(st),
                   PChar(st), 1+Length(st),
                   cb,
                   nil );
  err := GetLastError();
  if err<>NO_ERROR then
  begin
   ListBox1.Items.Add(AnsiString('USER_REQUEST_2:  ') + IntToStr(err));
  end else
  begin
   StaticText4.Caption := st;
   ListBox1.Items.Add('USER_REQUEST_2:   .');
  end;
 end else
  ListBox1.Items.Add('    ');
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
 if 0<>ListBox1.Items.Count then
  ListBox1.ItemIndex := ListBox1.Items.Count - 1;
end;

end.
